<?php
/* --------------------------------------------------------------
   AbstractSqlPagination.php 2020-04-21
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Criteria;

use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Class AbstractSqlPagination
 *
 * @package Gambio\Core\Criteria
 * @codeCoverageIgnore
 */
abstract class AbstractSqlPagination
{
    /**
     * @var int|null
     */
    protected $limit;
    
    /**
     * @var int|null
     */
    protected $offset;
    
    
    /**
     * @param QueryBuilder $query
     */
    public function applyToQuery(QueryBuilder $query): void
    {
        if ($this->limit !== null) {
            $query->setMaxResults($this->limit);
        }
        
        if ($this->offset !== null) {
            $query->setFirstResult($this->offset);
        }
    }
}